﻿QIPortalAPI.getForm = function()
{
	let frm = theForm;
	if (!frm)
	{
		frm = document.forms['Form'];
		if (!frm)
		{
			frm = document.Form;
		}
	}

	return frm;
};

QIPortalAPI.clearFormEvents = function()
{
	const frm = QIPortalAPI.getForm();
	if (frm)
	{
		let target = frm.__EVENTTARGET;
		if (!target)
			target = document.getElementById("__EVENTTARGET");
		if (target)
			target.value = '';


		let args = frm.__EVENTARGUMENT;
		if (!args)
			args = document.getElementById("__EVENTARGUMENT");
		if (args)
			args.value = '';
	}
};

QIPortalAPI.onEnterKey = function(evt, btnId)
{
	if (evt == null)
		evt = window.event;

	let keyCode = null;

	if (evt.which)
		keyCode = evt.which;
	else
		if (evt.keyCode)
		keyCode = evt.keyCode;

	if (13 === keyCode)
	{
		QIPortalAPI.makeClick(btnId);

		return false;
	}

	return true;
};

QIPortalAPI.isEnterKey = function(evt)
{
	return (evt.which === 13 || evt.keyCode === 13 || evt.keyIdentifier === 'U+000A' || evt.key === 'Enter' || evt.code === 'Enter' || evt.keyIdentifier === 'Enter')
}

QIPortalAPI.keyCode = function(evt)
{
	let keyCode = null;

	if (evt.which)
		keyCode = evt.which;
	else
	if (evt.keyCode)
		keyCode = evt.keyCode;

	return keyCode;
};

QIPortalAPI.inlinePlaceToBasket = function(event, hiddenField, idx, submitField)
{
    event = event || window.event;

    if (QIPortalAPI.keyCode(event) === 13)
    {
        return QIPortalAPI.placeToBasket(event, hiddenField, idx, submitField);
    }

	return true;
};

QIPortalAPI.placeToBasket = function(event, hiddenField, idx, submitField)
{
    QIPortalAPI.cancelEvent(event);

    if (QIPortalAPI.ajaxEnabled) {
		let target = event.target || event.srcElement;

		if (!((target.tagName === 'INPUT') && (target.type === 'text')))
        {
			let edit = $(target).find("input[id$='_quantity']");
			if (edit.length === 0)
                edit = $(target).children("input[id$='_quantity']");
            if (edit.length === 0)
                edit = $(target).siblings("input[id$='_quantity']");

            target = edit;
        }

        QIPortalAPI.getAjaxData("PutToBasket", 'goods=' + idx + '&quantity=' + $(target).val(), null);
        return false;
    }

    if ((hiddenField == null) || (hiddenField === ''))
        hiddenField = QIPortalAPI.targetEventField;

	const hiddenElem = document.getElementById(hiddenField);
	if (hiddenElem != null) {
        if (isNaN(idx)) {
            hiddenElem.value = idx;
        }
        else
            if (idx >= 0) {
                hiddenElem.value = idx.toString();
            }
    }
    if ((!submitField) && (QIPortalAPI.submitControl)) {
        submitField = QIPortalAPI.submitControl;
    }

    if (submitField) {
        QIPortalAPI.makeClick(submitField);
    }

    return false;
}

QIPortalAPI.makeClick = function(elementId)
{
	window.setTimeout(function()
	{
		let elem = elementId;
		if (typeof elementId == 'string')
			elem = document.getElementById(elementId);

		if (elem.click)
			elem.click();
		else
		{
			if ((elem.tagName === 'A') || (elem.tagName === 'a'))
			{
				const href = elem.href;
				if (href.substring(0, 11) === 'javascript:')
					eval(href.substring(11));
				else
					location.href = href;
			}
		}
	}, 200);
};

QIPortalAPI.cancelEvent = function(event)
{
	if (event == null)
		event = window.event;

	if (event != null)
	{
		if (event.preventDefault)
		{
			event.preventDefault();
			event.stopPropagation();
		}
		else
		{
			event.returnValue = false;
			event.cancelBubble = true;
		}
	}
};

QIPortalAPI.toggleMenu = function(id)
{
	const elem = document.getElementById(id);
	if (elem != null)
		elem.style.display = (elem.style.display === 'none') ? 'block' : 'none';
};

QIPortalAPI.hideElem = function()
{
	for (let i = 0; i < arguments.length; i++)
		jQuery(arguments[i]).hide();
};

QIPortalAPI.displayElem = function()
{
	for (let i = 0; i < arguments.length; i++)
		jQuery(arguments[i]).show();
};

QIPortalAPI.setFocus = function(elemId)
{
	const elem = (typeof (elemId) === 'string') ? document.getElementById(elemId) : elemId;
	if(elem != null)
		window.setTimeout(function() { elem.focus(); }, 100);
};

QIPortalAPI.setOnBlur = function(elemId)
{
	const edit = document.getElementById(elemId);
	if (edit != null)
	{
		edit.onblur = edit.onchange;
		edit.onchange = '';
	}
};

QIPortalAPI.hidePwdLabel = function(input)
{
	if (input != null)
	{
		const l = document.getElementById(input.id + '_lbl');
		if (l != null)
			l.style.display = 'none';

		//input.focus();
		setTimeout(function() { input.focus(); }, 10);
	}
};

QIPortalAPI.showPwdLabel = function(input)
{
	if ((input != null) && (input.value == ''))
	{
		const l = document.getElementById(input.id + '_lbl');
		if (l != null)
		{
			l.style.position = 'relative';
			l.style.left = (-input.clientWidth).toString() + 'px';
			l.style.top = '-1px';
			l.style.color = '#ACA899'; // 'gray';

			l.style.display = '';
		}
	}
};

QIPortalAPI.clearText = function(ctrl, defaultText)
{
	if (ctrl.qi_ignoreFocus)
	{
		delete ctrl.qi_ignoreFocus;
		return true;
	}

	if (ctrl.value == defaultText)
		ctrl.value = "";
	ctrl.style.color = "#000000";
	const orgType = ctrl._orgType;

	if (ctrl._orgType)
	{
		try
		{
			ctrl._orgType = null;
			ctrl.type = orgType;
		}
		catch (ex)
		{
			// IE hack
			const ctrl2 = document.createElement('<input id="' + ctrl.id + '" name="' + ctrl.name + '" title="' + ctrl.title + '" class="' + ctrl.className +
				'" style="' + ctrl.style.cssText + '" type="' + orgType + '" value="' + ctrl.value + '" />');

			ctrl2.onfocus = ctrl.onfocus;
			ctrl2.onblur = ctrl.onblur;
			ctrl2.onkeypress = ctrl.onkeypress;
			ctrl2.onkeydown = ctrl.onkeydown;
			ctrl2.onkeyup = ctrl.onkeyup;

			if (ctrl.hasAttribute('qi_emptyTextValue'))
				ctrl2.setAttribute('qi_emptyTextValue', ctrl.getAttribute('qi_emptyTextValue'));

			ctrl.parentNode.replaceChild(ctrl2, ctrl);

			window.setTimeout(function()
			{
				ctrl2.qi_ignoreFocus = true;
				ctrl2.focus();
			}, 100);
		}

	}
};

QIPortalAPI.resetText = function(ctrl, defaultText)
{
	if (defaultText)
		ctrl.setAttribute('qi_emptyTextValue', defaultText);

	if (ctrl.value == '')
	{
		ctrl.value = defaultText;
		ctrl.style.color = '#C0C0C0';
		ctrl._orgType = ctrl.type;

		if (ctrl.type != 'text')
		{
			try
			{
				ctrl.type = 'text';
			}
			catch (ex)
			{
				// IE hack
				const ctrl2 = document.createElement('<input id="' + ctrl.id + '" name="' + ctrl.name + '" title="' + ctrl.title + '" class="' + ctrl.className +
					'" style="' + ctrl.style.cssText + '" type="text" value="' + ctrl.value + '" _orgType="' + ctrl._orgType + '" />');
				ctrl2.onfocus = ctrl.onfocus;
				ctrl2.onblur = ctrl.onblur;
				ctrl2.onkeypress = ctrl.onkeypress;
				ctrl2.onkeydown = ctrl.onkeydown;
				ctrl2.onkeyup = ctrl.onkeyup;

				if (ctrl.hasAttribute('qi_emptyTextValue'))
					ctrl2.setAttribute('qi_emptyTextValue', ctrl.getAttribute('qi_emptyTextValue'));

				ctrl.parentNode.replaceChild(ctrl2, ctrl);
			}
		}

	}
};

QIPortalAPI.checkNewPasswordValues = function(event, ctrl1, ctrl2, pwdNotMatch)
{
	let value1 = ctrl1.value;
	let empty = ctrl1.getAttribute('qi_emptyTextValue');
	if ((empty) && (value1 == empty))
		value1 = "";

	let value2 = ctrl2.value;
	empty = ctrl2.getAttribute('qi_emptyTextValue');
	if ((empty) && (value2 == empty))
		value2 = "";

	if (value1 != value2)
	{
		setTimeout(function()
		{
			pwdNotMatch.style.display = '';

			if (document.activeElement != ctrl2)
				ctrl1.focus();
		}, 10);
	}
	else
	{
		pwdNotMatch.style.display = 'none';
	}
};

QIPortalAPI.incrementValue = function(idOrElem)
{
	let elem = idOrElem;
	if (typeof idOrElem == 'string')
        elem = document.getElementById(idOrElem);

	let value = parseInt(elem.value);
	if (isNaN(value))
        value = 0;

    elem.value = ++value;
};

QIPortalAPI.decrementValue = function(idOrElem)
{
	let elem = idOrElem;
	if (typeof idOrElem == 'string')
        elem = document.getElementById(idOrElem);

	let value = parseInt(elem.value);
	if ((isNaN(value)) || (value <= 0))
        value = 1;

    elem.value = --value;
};

QIPortalAPI.checkZeroBasketValue = function(idOrElem, zeroText)
{
	let elem = idOrElem;
	if (typeof idOrElem == 'string')
		elem = document.getElementById(idOrElem);

	const value = parseInt(elem.value);
	if ((isNaN(value)) || (value <= 0))
	{
		alert(zeroText);
		return false;
	}

	return true;
};

QIPortalAPI.validateCheckBox = function(validator)
{
	if ((!validator) || (!validator.controltovalidate))
		return false;

	const ctrl = document.getElementById(validator.controltovalidate);
	if (ctrl.getAttribute('validatorSet') != '1')
	{
		const clickFn = ctrl.onclick;
		ctrl.onclick = function()
		{
			if (ctrl.checked)
				validator.style.display = 'none';

			if (clickFn)
				clickFn.apply(this, arguments);
		};
		ctrl.setAttribute('validatorSet', '1');
	}

	return ctrl.checked;
};

QIPortalAPI.getScrollPosition = function()
{
	if (document.documentElement && document.documentElement.scrollTop)
		return document.documentElement.scrollTop; // IE6 +4.01
	if (document.body && document.body.scrollTop)
		return document.body.scrollTop; // IE5 or DTD 3.2
	return 0;
};

QIPortalAPI.setScrollPosition = function(yPosition, delayed)
{
	QIPortalAPI.lastSetScroll = yPosition;

	if (delayed === true)
		window.setTimeout(function() {  window.scrollTo(0, yPosition); }, 100);
	else
		window.scrollTo(0, yPosition);
};

QIPortalAPI.saveAutoComplete = function(formId)
{
	if ((window.external) && (typeof (window.external.AutoCompleteSaveForm) != 'undefined'))
		window.external.AutoCompleteSaveForm(document.getElementById(formId));
};


QIPortalAPI.quantityChanged = quantityChanged;
function quantityChanged(obj)
{
	const orgValue = obj.getAttribute("orgValue");
	const val1 = new Number(obj.value.replace(',', '.'));
	const val2 = new Number(orgValue.replace(',', '.'));

//    if (obj.value != orgValue)
    if (val1.valueOf() != val2.valueOf())
    {
        if (obj.value == '')
            obj.value = 0;

        if (checkForNumber(obj))                
        {
            obj.style.backgroundColor = '#ffffd5';
            obj.style.fontWeight = 'bold';
            obj.title = QIPortalAPI.getText('Text.OriginalValue') + ': ' + orgValue.toString();
        }
    }
    else
    {
        obj.style.color = '';
        obj.style.backgroundColor = '';
        obj.style.fontWeight = '';
        obj.title = '';
    }

};

QIPortalAPI.checkForNumber = checkForNumber;
function checkForNumber(obj, minValue, maxValue, noStyleSet)
{
	const val = new Number(obj.value.replace(',', '.'));
	let err = isNaN(val);
	if (!err)
	{
		err = (val < minValue) || ((val > maxValue) && (!((minValue == 0) && (maxValue == -1))));
	}

    if (err)
    {
    	if (!noStyleSet)
    	{
    		obj.style.color = 'yellow';
    		obj.style.backgroundColor = 'red';
    		obj.style.fontWeight = 'bold';
    		obj.title = QIPortalAPI.getText('Text.InvalidValue') + ': ' + obj.value.toString() + '!';
    	}
        
        return false;
    }

    if (!noStyleSet)
    {
    	obj.style.color = '';
    	obj.style.backgroundColor = '';
    	obj.style.fontWeight = '';
    	obj.title = '';
    }

    return true;
};

QIPortalAPI.checkKeyIsNumber = checkKeyIsNumber;
function checkKeyIsNumber(e)
{
	if (e == null)
		e = window.event;

	if (e.charCode === 0)
		return true;

	const unicode = e.charCode ? e.charCode : e.keyCode;
	if (!((e.shiftKey && unicode === 45) || unicode === 8 || unicode === 9 || (unicode >= 44 && unicode <= 46) || (unicode >= 48 && unicode <= 57)))
	{
		return false;
	}

	return true;
};

QIPortalAPI.checkIntQuantity = function(e)
{
	if (e == null)
		e = window.event;

	const unicode = e.charCode ? e.charCode : e.keyCode;
	if (!(unicode == 8 || unicode == 9 || (unicode >= 48 && unicode <= 57)))
	{
		if ((e.ctrlKey && unicode == 118) || (e.shiftKey && unicode == 45))
		{
			// handle paste
		}
		else
			if (e.charCode === 0)
				return true;

		return false;
	}

	return true;
};


QIPortalAPI.getCheckedRadio = function(id)
{
	const radioButtons = document.getElementsByName(id);
	for (let x = 0; x < radioButtons.length; x++)
	{
		if (radioButtons[x].checked)
		{
			return radioButtons[x].value;
		}
	}

	return null;
};

QIPortalAPI.alert = function(message, title, callback)
{
	let msg = message;

	if (typeof jQuery != 'undefined')
	{
		let clsName = null;

		const cfg = {
			buttons: {
				'Ok': function () {
					jQuery(this).dialog('close');
				}
			},
			close: function (event, ui) {
				jQuery(this).remove();
				if (typeof callback == 'function') {
					callback.call(this);
				}
			},
			dialogClass: 'alert',
			resizable: false,
			draggable: false,
			title: title,
			modal: true
		};

		if (typeof (message) == 'object')
		{
			msg = message.message;
			clsName = message.className;
			if (message.width)
				cfg.width = message.width;
		}

		jQuery('<div class="Normal Clear AlertDialog' + ((clsName) ? ' ' + clsName : '') + '"></div>').dialog(cfg).html(msg);
	}
	else
	{
		window.alert(msg);
	}
};

QIPortalAPI.selectRegUserType = function(org)
{
	let hDiv;
	const pDiv = document.getElementById('regForm_Person');
	const oDiv = document.getElementById('regForm_Organization');

	const hDivs = [];
	if (org)
	{
		if (pDiv)
		{
			pDiv.style.display = 'none';
			hDivs.push(jQuery(pDiv));
		}
		if (oDiv)
			oDiv.style.display = 'block';

		hDiv = jQuery('.regFormPerson');
		hDivs.push(hDiv);
		hDiv.hide();
		jQuery('.regFormOrganization').show();
	}
	else
	{
		if (oDiv)
			pDiv.style.display = 'block';
		if (pDiv)
		{
			oDiv.style.display = 'none';
			hDivs.push(jQuery(oDiv));
		}

		hDiv = jQuery('.regFormOrganization');
		hDivs.push(hDiv);
		hDiv.hide();
		jQuery('.regFormPerson').show();
	}

	window.setTimeout(function() {
		if (!Page_Validators)
			return;

		if (!QIPortal.org_Page_Validators)
		{
			QIPortal.org_Page_Validators = Page_Validators.slice(0);
		} else
		{
			Page_Validators = QIPortal.org_Page_Validators.slice(0);
		}

		for (let cnt = 0; cnt < hDivs.length; cnt++)
		{
			const spans = hDivs[cnt].find('span');
			if (spans.length)
			{
				for (let i = 0; i < spans.length; i++)
				{
					const idx = jQuery.inArray(spans[i], Page_Validators);
					if (idx > -1)
						Page_Validators.splice(idx, 1);
				}
			}
		}
	}, 100);
	//ValidatorUpdateDisplay();
	//ValidatorUpdateIsValid();
	//Page_ClientValidate("");
};

QIPortalAPI.getUserSettings = function (name, id, successFn)
{
	const param = {act: 'get', name: name};
	if (id)
		param.id = id;

	jQuery.ajax({
		url: QIPortalAPI.appPath + 'UserSettings.aspx?' + jQuery.param(param),
		method: "GET",
		cache: false,
		success: successFn
	});
};

QIPortalAPI.setUserSettings = function (name, id, value, successFn)
{
	const param = {act: 'set', name: name};
	if (id)
		param.id = id;
	if (value)
		param.value = value;

	jQuery.ajax({
		url: QIPortalAPI.appPath + 'UserSettings.aspx?' + jQuery.param(param),
		method: "GET",
		cache: false,
		//dataType: "xml",
		success: successFn
	});
};

QIPortalAPI.stripNonValidXMLCharacters = function (value)
{
	let current;
	let out = "";

	for (let i = 0; i < value.length; i++)
	{
		current = value.charCodeAt(i);

		if ((current == 0x9) ||
			(current == 0xA) ||
			(current == 0xD) ||
			((current >= 0x20) && (current <= 0xD7FF)) ||
			((current >= 0xE000) && (current <= 0xFFFD)) ||
			((current >= 0x10000) && (current <= 0x10FFFF)))
		{
			out += value.charAt(i);
		}
	}

	return out;
};

QIPortalAPI.checkNonValidXMLCharacters = function (control)
{
	let checking = false;

	$(control).on('input change', function(e)
	{
		if (checking)
			return true;

		checking = true;
		try
		{
			const stripped = QIPortal.stripNonValidXMLCharacters(this.value);
			if (stripped != this.value)
			{
				alert('Text obsahuje chybné znaky. Z důvodu kompatibility budou z textu odstraněny.');
				$(control).val(stripped);
			}
		}
		finally
		{
			checking = false;
		} 

		return true;
	});
};

QIPortalAPI.showRequiredFieldMarks = function()
{
	if (typeof (Page_Validators) != 'undefined')
	{
		for (let i = 0; i < Page_Validators.length; i++)
		{
			const validator = Page_Validators[i];
			if (validator.getAttribute('data-type') == 'required')
			{
				$(validator).show();
			}
		}
	}
};

QIPortalAPI.hideRequiredFieldMarks = function()
{
	if (typeof (Page_Validators) != 'undefined')
	{
		for (let i = 0; i < Page_Validators.length; i++)
		{
			const validator = Page_Validators[i];
			if (validator.getAttribute('data-type') === 'required')
			{
				$(validator).hide();
			}
		}
	}
};

QIPortalAPI.checkFieldValidators = function()
{
	let isOK = true;
	
	if (typeof (Page_Validators) != 'undefined')
	{
		for (let i = 0; i < Page_Validators.length; i++)
		{
			const val = Page_Validators[i];
			if (typeof(val.evaluationfunction) == "function")
			{
				val.isvalid = val.evaluationfunction(val);
			}

			if (val.isvalid)
			{
				$(val).hide();
			}
			else
			{
				isOK = false;
				$(val).show();
			}
		}
	}

	return isOK;
};

QIPortalAPI.getAjaxData = function (type, param, callback)
{
    QIPortalAPI.showSplash();
    jQuery.ajax({
        url: QIPortalAPI.appPath + 'Modules/QIPortal/AjaxData.aspx?ax_isAjax=1&ax_dataType=' + type + '&' + ((typeof param === 'string') ? param : jQuery.param(param)),
        type: 'GET',
        cache: false,
        success: function (data)
        {
            for (let name in data)
            {
                if (data.hasOwnProperty(name))
                {
					const content = data[name];

					if ((callback) && (callback(name, content)))
                        continue;

                    if (content.startsWith('<script'))
                    {
                        $(document.body).append(content);
                    }
                    else
                    {
                        $('.qishop-' + name + 'ModuleContent').html(content);
                    }
                }
            }
        },
        complete: function(ajax, status)
        {
            QIPortalAPI.hideSplash();
        }
    });
};

QIPortalAPI.showSplash = function()
{
	showSplash();
};

QIPortalAPI.hideSplash = function()
{
	hideSplash();
};

QIPortalAPI.cookiesAllowed = function ()
{
	//if ((jQuery) && (jQuery.cookie) && (jQuery.cookie('cc_cookie_decline') === 'cc_cookie_decline'))
	//	return false;

	if ((jQuery) && (jQuery.cookieBar))
	{
		return jQuery.cookieBar('cookies');
	}

	return true;
};

let _orgCookiesAllowed = null;
QIPortalAPI.setCookiesAllowed = function (state)
{
	if (_orgCookiesAllowed == null)
		_orgCookiesAllowed = QIPortalAPI.cookiesAllowed; 
	
	QIPortalAPI.cookiesAllowed = function () { return (state !== undefined) ? state : _orgCookiesAllowed() };
	
	if ((jQuery) && (jQuery.cookieBar))
	{
		if (state !== undefined)
		{
			jQuery.cookieBar('set', (state === true) ? 'accepted' : 'declined');
		}
		else
		{
			if (jQuery.cookieBar('value') !== '')
			{
				jQuery.cookieBar('remove');
			}
			jQuery.cookieBar(QIPortalAPI.cookieBarOptions);
			//setTimeout(function(){ window.scrollTo(0, 0); }, 300);
		}
	}
};

QIPortalAPI.initializeGA = function (trackId)
{
	const ecomm = QIPortalAPI.GAEcommerce === true;
	if (QIPortalAPI.cookiesAllowed())
	{
		ga('create', trackId, 'auto');

		if (ecomm)
			ga('require', 'ec');
		else
			ga('send', 'pageview');

		QIPortalAPI.gaInitialized('ua');
	}
};

QIPortalAPI.initializeGA4 = function (trackId)
{
	//var ecomm = QIPortalAPI.GAEcommerce === true;
	if (QIPortalAPI.cookiesAllowed())
	{
		window.dataLayer = window.dataLayer || [];

		function gtag(){dataLayer.push(arguments);}

		gtag('js', new Date());
		gtag('config', trackId);
		
		QIPortalAPI.gaInitialized('ga4');
	}
};

QIPortalAPI.gaInitialized = function (version)
{
    // to be overriden in user script
};

QIPortalAPI.setExpiration = function (timeout)
{
	QIPortalAPI.expirationTimeout = timeout;
	QIPortalAPI.expirationTime = Date.now() + timeout*60000;

	const timeoutDiff = (timeout > 5) ? 5 : timeout - 1;

	window.setTimeout(function()
	{
		QIPortalAPI.showExpirationdDialog();
	}, (timeout - timeoutDiff)*60000);
}

QIPortalAPI.showExpirationdDialog = function()
{
	let expInfo;
	let elem = $('.ExpirationDialog');
	if (elem.length === 0)
	{
		elem = $('<div>', {"class": "ExpirationDialog"});
		expInfo = $('<div>', {"class": "ExpirationInfo", "hint": "Klikněte pro obnovu.", "title": "Klikněte pro obnovu."});
		elem.append(expInfo);
		$(document.body).append(elem);

		expInfo.on('click', function ()
		{
			fetch(QIPortalAPI.appPath + 'api/qiPortal/user/renewAuthTicket',
			{
				method: 'GET',
				headers: {
					'Accept': 'application/json',
				},
			}).then(response => response.json())
				.then(response => {
					if (response.result === "-1") {
						alert('Přihlášení vypršelo a není možné jej prodloužit. Data nyní nemohou být uložena - zkopírujte rozdělanou práci a přihlašte se znovu.');
					} else {
						window.clearInterval(QIPortalAPI.expirationTimeoutInterval);
						QIPortalAPI.setExpiration(parseInt(response.result));
					}
				});
		});
	}
	else
	{
		expInfo = $('.ExpirationInfo');
	}

	const showInfo = function () {
		let diffSeconds;
		let diffMinutes;
		let diff = (QIPortalAPI.expirationTime - Date.now()) / 1000;
		if (diff > 0) {
			if (diff > (3600)) {
				const diffHours = Math.floor(diff / 3600);
				diff -= diffHours * 3600;
				diffMinutes = Math.floor(diff / 60) % 60;
				diff -= diffMinutes * 60;
				diffSeconds = Math.floor(diff % 60);
				expInfo.html('Vaše přihlášení vyprší za ' + String(diffHours).padStart(2, '0') + ':' + String(diffMinutes).padStart(2, '0') + ':' + String(diffSeconds).padStart(2, '0'));
			} else {
				diffMinutes = Math.floor(diff / 60) % 60;
				diff -= diffMinutes * 60;
				diffSeconds = Math.floor(diff % 60);
				expInfo.html('Vaše přihlášení vyprší za ' + String(diffMinutes).padStart(2, '0') + ':' + String(diffSeconds).padStart(2, '0'));
			}
		} else {
			window.clearInterval(interval);
			expInfo.html('Vaše přihlášení vypršelo, data nyní nemohou být uložena.');
		}
	};

	let interval = window.setInterval(function()
	{
		showInfo();
	}, 1000);
	showInfo();

	QIPortalAPI.expirationTimeoutInterval = interval;
}

QIPortalAPI.onBeginRequest = function (sender, e)
{
    QIPortalAPI.showSplash();
};

QIPortalAPI.onEndRequest = function (sender, e)
{
    QIPortalAPI.hideSplash();
};

QIPortalAPI.setJQueryExtensions = function()
{
    $.extend({
        getUrlVars: function ()
        {
            if ($.parserdQueryString)
                return $.parserdQueryString;

			const vars = [];
			let hash;
			const idx = window.location.href.indexOf('?');
			if (idx > -1)
            {
				const hashes = window.location.href.slice(idx + 1).split('&');
				for (let i = 0; i < hashes.length; i++)
                {
                    hash = hashes[i].split('=');
                    vars.push(hash[0]);
                    //vars[hash[0].toLowerCase()] = hash[1];
                    vars[hash[0]] = hash[1];
                }
            }

            $.parserdQueryString = vars;
            return vars;
        },
        getUrlVar: function (name)
        {
            if (!name)
                return null;

            //name = name.toLowerCase();
			const urlVars = $.getUrlVars();
			if (urlVars.hasOwnProperty(name))
                return urlVars[name];

            return null;
        }
    });


    $.extend({
        getAllComments: function (el, contentFilter)
        {
			return $(el).find(":not(iframe)").addBack().contents().filter(function ()
            {
                return ((this.nodeType === 8) && ((!contentFilter) || (this.nodeValue == contentFilter)));
            });
        }
    });

/*
    $.extend({
        updateQueryStringParam: function (key, value)
        {
            var baseUrl = [location.protocol, '//', location.host, location.pathname].join('');
            var urlQueryString = document.location.search;
            var newParam = key + '=' + value,
            params = '?' + newParam;

            // If the "search" string exists, then build params from it
            if (urlQueryString) {
                var keyRegex = new RegExp('([\?&])' + key + '[^&]*');
                // If param exists already, update it
                if (urlQueryString.match(keyRegex) !== null) {
                    params = urlQueryString.replace(keyRegex, "$1" + newParam);
                } else { // Otherwise, add it to end of query string
                    params = urlQueryString + '&' + newParam;
                }
            }

            return baseUrl + params;
        }
*/
    $.extend({
        updateQueryStringParam: function (key, value)
        {
			let items = key;
			if (typeof (key) === 'string')
            {
                items = {};
                items[key] = value;
            }

			const baseUrl = [location.protocol, '//', location.host, location.pathname].join('');
			const urlVars = $.getUrlVars();
			if (urlVars.length)
                urlVars.length = 0;
			const newVars = {};

			for (let urlVar in urlVars)
            {
                if (urlVars.hasOwnProperty(urlVar))
                {
                    if (items.hasOwnProperty(urlVar))
                    {
                        value = items[urlVar];
                        if (value != null)
                            newVars[urlVar] = value;
                        delete items[urlVar];
                    }
                    else
                    {
                        newVars[urlVar] = urlVars[urlVar];
                    }
                }
            }

            for (let item in items)
            {
                if (items.hasOwnProperty(item))
                {
                    value = items[item];
                    if (value != null)
                        newVars[item] = items[item];
                }
            }

			const qs = $.param(newVars);
			return baseUrl + ((qs) ? '?' + qs : '');
        }
    });
}

QIPortalAPI.loadCSS = function (href)
{
	const cssLink = $('<link>');

	cssLink.attr({
		rel: 'stylesheet',
		type: 'text/css',
		href: href
	});

	$('head').append(cssLink);
}

QIPortalAPI.showBrowserUnsupported = function(text)
{
	let elem = $('#unsupportedBrowserMsg') || $('.unsupportedBrowserMsg');
	if (elem.length === 0)
	{
		elem = $('<div id="unsupportedBrowserMsg" class="UnsupportedBrowserMsg"></div>').appendTo($(document.body));
	}
	elem.html(text);
	elem.show();
}

QIPortalAPI.showImageDetailOnClick = function ()
{
	const FORMATTED_TEXT_HANDLER_IMAGE_ON_CLICK = '.FormattedTextHandlerImageOnClick';
	const BACKDROP_CLASS = 'backdrop';
	const IMAGE_DETAIL_CLASS = 'imageDetail';
	const IMAGE_WRAPPER_CLASS = 'imageWrapper';
	const CLOSE_BUTTON_CLASS = 'closeButton';
	const CLOSE_BUTTON_SPAN_ONE_CLASS = 'closeButtonSpanOne';
	const CLOSE_BUTTON_SPAN_TWO_CLASS = 'closeButtonSpanTwo';
	const SIZE_BUTTON = 'SizeButton';
	const NO_SELECT = 'noSelect';


	let scale = 1;
	let boundHandleKeypress = null;
	let displayedImageElement;
	

	const divs = document.querySelectorAll(FORMATTED_TEXT_HANDLER_IMAGE_ON_CLICK);
	let backdrop;
	divs.forEach((div, index) => {
		const images = findImagesInElement(div);

		images.forEach((image, imageIndex) => {
			image.style.cursor = "pointer";
			image.onclick = function () {
				showImageDetail(image);
			};
		});
	});

	function handleKeypress(closeFunction, event) {
		if (event.key === 'Escape') {
			closeFunction();
			document.removeEventListener('keydown', boundHandleKeypress); 
		}
		else if (event.key === '+') { 
			changeImageSize(true); 
		}
		else if (event.key === '-') {
			changeImageSize(false);
		}
	}

	function findImagesInElement(element) {
		const images = element.querySelectorAll('img');
		return images;
	}

	function showImageDetail(image) {
		createBackdrop();
		displayImageOnBackdrop(image);
		boundHandleKeypress = handleKeypress.bind(null, closeImageDetail); 
		document.addEventListener('keydown', boundHandleKeypress);
	}
	function closeImageDetail() {
		document.body.removeChild(backdrop);
		scale = 1;
		document.removeEventListener('keydown', boundHandleKeypress);
		displayedImageElement = null;
	}

	function createBackdrop() {
		backdrop = document.createElement('div');
		backdrop.classList.add(BACKDROP_CLASS);
		document.body.appendChild(backdrop);
		
		backdrop.onclick = function () {
			closeImageDetail();
		};		
	}

	function displayImageOnBackdrop(clickedImage) {
		const imageWrapper = createWrapper();
		displayedImageElement = createImageElement(clickedImage);
		imageWrapper.appendChild(displayedImageElement);
		addCloseButtonToWrapper(imageWrapper);
		
		const controlpanel = addControlPanelToWrapper(imageWrapper);  
		addSizeButtonsToPanel(controlpanel);
		backdrop.appendChild(imageWrapper);
	}

	function createImageElement(clickedImage) {
		let imageElement = document.createElement('img');

		imageElement.src = clickedImage.src;
		imageElement.alt = clickedImage.alt;
		imageElement.classList.add(IMAGE_DETAIL_CLASS);

		imageElement.onclick = function (event) {
			event.stopPropagation();
		};
		return imageElement;
	}

	function createWrapper() {
		let imageWrapper = document.createElement('div');
		imageWrapper.classList.add(IMAGE_WRAPPER_CLASS);

		imageWrapper.onclick = function (event) {
			event.stopPropagation();
		};
		return imageWrapper;
	}

	function addCloseButtonToWrapper(wrapper) {
		const closeButton = document.createElement('div');
		closeButton.classList.add(CLOSE_BUTTON_CLASS);
		createCloseButtonSpans(closeButton);
		closeButton.onclick = function (event) {
			closeImageDetail();
		};
		wrapper.appendChild(closeButton);
	}

	function createCloseButtonSpans(closeButton) {
		const span1 = document.createElement('span');
		const span2 = document.createElement('span');

		span1.classList.add(CLOSE_BUTTON_SPAN_ONE_CLASS);
		span2.classList.add(CLOSE_BUTTON_SPAN_TWO_CLASS);

		closeButton.appendChild(span1);
		closeButton.appendChild(span2);
	}

	function addSizeButtonsToPanel(controlPanel) {	
		addDecreaseButton(controlPanel);
		addIncreaseButton(controlPanel);
	}
	function addIncreaseButton(controlPanel) {
		const increaseButton = document.createElement('div');
		increaseButton.classList.add(SIZE_BUTTON);
		increaseButton.classList.add(NO_SELECT);
		increaseButton.innerText = '+';
		increaseButton.onclick = function (event) {
			event.stopPropagation();
			changeImageSize(displayedImageElement, true);
		};
		controlPanel.appendChild(increaseButton);
	}

	function addDecreaseButton(controlPanel) {
		const decreaseButton = document.createElement('div');
		decreaseButton.classList.add(SIZE_BUTTON);
		decreaseButton.classList.add(NO_SELECT);
		decreaseButton.innerText = '-';
		decreaseButton.onclick = function (event) {
			event.stopPropagation();
			changeImageSize(false);
		};
		controlPanel.appendChild(decreaseButton);
	}

	function addControlPanelToWrapper(wrapper) {
		const controlPanel = document.createElement('div');
		controlPanel.classList.add('controlPanel');
		wrapper.appendChild(controlPanel);
		return controlPanel;
	}

	function getOriginalSize(imageElement) {
		return {
			originalWidth: imageElement.naturalWidth,
			originalHeight: imageElement.naturalHeight
		};

	}

	function changeImageSize(isIncrease) { 
		changeScale(isIncrease);
		const sizeObject = getOriginalSize(displayedImageElement);

		let newWidth = sizeObject.originalWidth * scale;
		let newHeight = sizeObject.originalHeight * scale;		

		if ((document.documentElement.clientWidth * 0.9 < newWidth || document.documentElement.clientHeight * 0.9 < newHeight) && isIncrease) {
			changeScale(false); //scale is changed before img is resized and if it is higher then max values, it is changed back
			return;
		}
		if (scale < 0.5) {
			changeScale(true);
			return;
		}

		displayedImageElement.style.width = newWidth + "px";
		displayedImageElement.style.height = newHeight + "px";
	}
	function changeScale(isIncrease) {
		if (isIncrease) {
			scale = scale * 1.2;
		}
		else {
			scale = scale / 1.2;
		}
	}
}



function showSplash(prepare)
{
	let splash = $('#_splash_');
	if (splash.length > 0)
	{
		splash.show();
		return;
	}

	splash = $('<div>', {
		'id': '_splash_',
		'style': 'position:fixed;background-color:#fefefe;top:0;right:0;bottom:0;left:0;opacity:0.5;filter:alpha(opacity=60)' + ((prepare) ? ';display:none' : '')
		,'class': 'splash'
	}).appendTo('body');

	$('<img src="' + QIPortalAPI.appPath + 'Modules/QIPortal/images/big-circle-ball.gif" style="position: absolute; top: 50%;  left: 50%;" />').appendTo(splash);
};

function hideSplash()
{
    $('#_splash_').hide();
}

function getSplashSize()
{
	let _Width, _Height;

	if (window.innerHeight && window.scrollMaxY || window.innerWidth && window.scrollMaxX)
  {
     _Height = window.innerHeight + window.scrollMaxY;
     _Width = window.innerWidth + window.scrollMaxX;
	  const deff = document.documentElement;
	  const wff = (deff && deff.clientWidth) || document.body.clientWidth || window.innerWidth || self.innerWidth;
	  const hff = (deff && deff.clientHeight) || document.body.clientHeight || window.innerHeight || self.innerHeight;
	  _Width -= (window.innerWidth - wff);
    _Height -= (window.innerHeight - hff);
  }
  else
  if (document.body.scrollHeight > document.body.offsetHeight || document.body.scrollWidth > document.body.offsetWidth)
  {
    _Height = document.body.scrollHeight;
    _Width = document.body.scrollWidth;
  }
  else
  {
    _Height = document.body.offsetHeight;
    _Width = document.body.offsetWidth;
  }

  return {width: _Width, height: _Height};
};


const QITreeView2 = new Object();
QITreeView2.setExpanded = function(elem, expand, cssPrefix)
{
	const c = elem.className;

	const show = (cssPrefix) ? cssPrefix + 'Show' : 'Show';
	const hide = (cssPrefix) ? cssPrefix + 'Hide' : 'Hide';

	if (c.indexOf(show) > -1)
	{
		if (!expand)
		{
			elem.className = c.replace(' ' + show, '') + ' ' + hide;
		}
	}
	else
	{
		if (expand)
			elem.className = c.replace(' ' + hide, '') + ' ' + show;
	}
};

QITreeView2.toggle = function(elem, expandLevels, cssPrefix)
{
	let div = elem.parentNode;
	let c = div.parentNode.className;

	if (!expandLevels)
		expandLevels = 1;

	if (!cssPrefix)
		cssPrefix = '';

	const expand = (c.indexOf(cssPrefix + 'Show') == -1);
	QITreeView2.setExpanded(div.parentNode, expand, cssPrefix);

	let next = div.parentNode.nextSibling;
	while (next)
	{
		if ((!next) || ((next.className) && (next.className.indexOf(cssPrefix + "Level") == 0)))
			break;

		next = next.nextSibling;
	}

	if (next)
	{
		QITreeView2.setExpanded(next, expand, cssPrefix);

		c = next.className;
		let splitted = c.split(' ');
		const level = parseInt(splitted[0].substring(cssPrefix.length + 5));

		const subDivs = next.getElementsByTagName('div');
		const levels = [];
		let i;
		for (i = 0; i < subDivs.length; i++)
		{
			div = subDivs[i];
			c = div.className;
			if (c.indexOf(cssPrefix + "Level") == 0)
			{
				splitted = c.split(' ');
				const divLevel = parseInt(splitted[0].substring(cssPrefix.length + 5));
				if ((divLevel > level) && (divLevel < level + expandLevels))
					levels.push(div);
			}
		}
		for (i = 0; i < levels.length; i++)
		{
			div = levels[i];
			QITreeView2.setExpanded(div, expand, cssPrefix);
		}
	}
};



function ignoreOnEndRequest(sender, e)
{
	const err = e.get_error();
	if (err)
	{
		if (err.name == "Sys.WebForms.PageRequestManagerServerErrorException")
		{
			e.set_errorHandled(true);
		}
	}
};

if (!document.all) //non-ie
{
	QIPortalAPI.attachEvent(window, "beforeunload", function()
	{
		try
		{
			const instance = Sys.WebForms.PageRequestManager.getInstance();
			if (instance)
				instance.add_endRequest(ignoreOnEndRequest);
		}
		catch (ex) { console.log(ex); }
	});
}

String.prototype.htmlEncode = function()
{
	return this.replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
};

String.prototype.htmlDecode = function() {
	return this.replace(/&#(\d+);/g, function(match, dec) {
		return String.fromCharCode(dec);
	});
};


$(function ()  // document ready
{
    QIPortalAPI.setJQueryExtensions();
	showSplash(true);
	QIPortalAPI.showImageDetailOnClick();

    if (typeof (ValidatorUpdateDisplay) != 'undefined') {
		const originalValidatorUpdateDisplay = ValidatorUpdateDisplay;

		ValidatorUpdateDisplay = function (val) {
            originalValidatorUpdateDisplay(val);

			const div = $('#' + val.controltovalidate.replace(/\^/g, '\\^')); //.closest("div");
            if (!val.isvalid) {
                QIPortalAPI.hideSplash();
                div.addClass('ValidationError');
            }
            else {
                div.removeClass('ValidationError');
            }
        };
    }

    if (QIPortalAPI.showRequiredFieldMarksOnLoad)
	{
		QIPortalAPI.checkFieldValidators();
	}

    try {
        $(window).on("unload", function () {
            QIPortalAPI.showSplash();
        });
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(QIPortalAPI.onBeginRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(QIPortalAPI.onEndRequest);
    }
    catch (ex) { console.log(ex); }

    document.addEventListener('cookieState', function(state) 
    {
        fetch(QIPortalAPI.appPath + 'api/qiPortal/user/setCookieState?value=' + state.detail.cookieEnabled, 
        {
            method: 'GET',
            headers: {
                'Accept': 'application/json',
            },
        });
    });
});

